VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clscolFindFiles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'*************************************************************
'Module    : clscolFindFiles
'Author    : Monday, January 25, 1999 - Nikolaos D. Dimopoulos
'            NickDD@ISM-Solutions.com, NickDim@msn.com
'Project   : FindFiles
'*************************************************************
Option Explicit
DefInt A-Z

Private Declare Function CharLower Lib "user32" Alias "CharLowerA" _
    (ByVal lpsz As String) As String

Private Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" _
    (ByVal lpFileName As String, _
           lpFindFileData As WIN32_FIND_DATA) As Long

Private Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" _
    (ByVal hFindFile As Long, _
           lpFindFileData As WIN32_FIND_DATA) As Long

Private Declare Function FindClose Lib "kernel32" _
    (ByVal hFindFile As Long) As Long

Private Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type
 
Private Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * 255
    cAlternate As String * 14
End Type
 
Private mCol As Collection
 
Public Function Add(Optional sKey As String) As clsFiles
    
    ' create a new object
    Dim objNewMember As clsFiles
    
    Set objNewMember = New clsFiles
    
    'set the properties passed into the method
    If Len(sKey) = 0 Then
        mCol.Add objNewMember
    Else
        mCol.Add objNewMember, sKey
    End If
    
    ' Return the object created
    Set Add = objNewMember
    
    Set objNewMember = Nothing
    
End Function
 
Public Property Get Item(vntIndexKey As Variant) As clsFiles
    Set Item = mCol(vntIndexKey)
End Property
 
Public Property Get Count() As Long
    Count = mCol.Count
End Property
 
Public Sub Remove(vntIndexKey As Variant)
    mCol.Remove vntIndexKey
End Sub
 
Private Sub Class_Initialize()
    Set mCol = New Collection
End Sub
 
Private Sub Class_Terminate()
    Set mCol = Nothing
End Sub
 
Public Sub Clear()
    Set mCol = Nothing
End Sub

Public Sub Populate(strPath As String, strFilter As String)
    
    Dim WFD As WIN32_FIND_DATA
    Dim lngHandle As Long
    Dim strFile As String
    
    If Len(strPath) = 0 Then strPath = "C:\"
    If Right$(strPath, 1) <> "\" Then strPath = strPath & "\"
    If Len(strFilter) = 0 Then strFilter = "*.*"
    
    Populate_Files strPath, strFilter
    
    lngHandle = FindFirstFile(strPath & strFilter & Chr$(0), WFD)
    
    If lngHandle <> -1 Then
        strFile = TrimNull(WFD.cFileName)
        WFD.dwFileAttributes = vbDirectory
        
        Do While FindNextFile(lngHandle, WFD)
            strFile = TrimNull(WFD.cFileName)
            
            ' Ignore the 2 standard root entries
            If (strFile <> ".") And (strFile <> "..") Then
            
                If (WFD.dwFileAttributes And vbDirectory) Then
                    Populate strPath & strFile, strFilter
                End If
                
            End If
        Loop
    End If
    
    FindClose (lngHandle)
    
End Sub

Private Sub Populate_Files(strFolder As String, strFilter As String)
    
    Dim WFD As WIN32_FIND_DATA
    Dim lngHandle As Long
    
    lngHandle = FindFirstFile(strFolder & strFilter, WFD)
    
    If lngHandle <> -1 Then
    
    Do
        Add Count + 1
        Item(Count).Path = CharLower(Trim$(strFolder))
        Item(Count).FileName = CharLower(TrimNull(WFD.cFileName))
    Loop Until FindNextFile(lngHandle, WFD) = 0
    
    End If
    
    FindClose (lngHandle)
    
End Sub
 
Private Function TrimNull(strStart As String) As String
    
    Dim intPos As Integer
    
    intPos = InStr(strStart, Chr(0))
    
    If intPos Then
        TrimNull = Left$(strStart, intPos - 1)
        Exit Function
    End If
    
    ' if this far, there was no Chr$(0), so return the string
    TrimNull = strStart
    
End Function
